rm(list=ls())
library(cmdstanr)
library(bayesplot)
library(posterior)
library(mcmcplots)
library(magrittr)
library(multipanelfigure)
library(data.table)
library(tidylog)
library(tidyverse)

setwd("")


# Lets say we had set up an experiment in which we applied a continuous treatment (year) ranging 
# in magnitude from 0 to 16 to a total of 16 sampling units (n=16) and then measured a 
# response (y) from each unit. 

## generate data
data <- list(
  n=16,
  x = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),
  y=c(35.70,35.85,43.29,34.35,33.15,39.58,31.80,21.67,23.07,22.77,29.62,23.80,22.50,19.55,14.72,24.93)
  )

example3 <- cmdstan_model("STAN/example3.stan")


initial_values <- list(

  )

example3_fit <- example3$sample(data=data,
                                seed=123,
                                iter_warmup=2000,
                                iter_sampling=2000,
                                chains = 2,
                                parallel_chains=2,
                               save_warmup = TRUE,
                               thin=1,
                               max_treedepth=15,
                               init=initial_values)
example3_fit$summary()

post_draws <- example3_fit$draws() # this is how you store the chain from Stan
#figure2 <- multi_panel_figure(columns = 3, rows = 3, panel_label_type = "upper-roman")
figure1 <- multi_panel_figure(columns = 4, rows = 4, panel_label_type = "upper-roman")
figure1 %<>%
  fill_panel(mcmc_trace(post_draws,pars='beta0'), column = 1:2, row = 1) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars='beta0'), column = 1:2, row = 2) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='beta0'), column = 3:4, row = 1:2) %>%
  fill_panel(mcmc_trace(post_draws,pars='beta1'), column = 1:2, row = 3) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars='beta1'), column = 1:2, row = 4) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='beta1'), column = 3:4, row = 3:4)
figure1





posterior_sample <- data.frame(example3_fit$draws(format = "matrix",inc_warmup = FALSE))

sigma <- mean(posterior_sample[,'sigma'])
log_lik_theta_hat <- rep(0,16)
for(i in 1:16){
  mu <- mean(posterior_sample[,paste('mu.',i,'.',sep='')])
    log_lik_theta_hat[i] <- dnorm(y[i],mean=mu,sd=sigma,log=TRUE)
}


total_log_lik_theta_hat <- sum(log_lik_theta_hat)
mean_log_lik_theta <- mean(posterior_sample[,'log_lik'])
#getwd()
pD <- 2 * (total_log_lik_theta_hat - mean_log_lik_theta)
DIC <- (-2 * total_log_lik_theta_hat) + (2*pD)
DIC3 <- (-2 * mean_log_lik_theta) + (pD)


